-- Creature Constructor
-- MaxScript by Josh Siegle, David Sheinberg (Brown U)
-- Last updated: 10/2014
-- 
-- Merges body parts and sets parameters


fn creature1 hinfo tinfo minfo = 
(

partdir = "c:/stimuli/creatures/Family1/"

delete $Mouth
delete $Head
delete $Tentacle


head_num = hinfo[1]
tentacle_num = tinfo[1] 
mouth_num = minfo[1]

head_name = "Head" + head_num as String
tentacle_name = "Tentacle" + tentacle_num as String
mouth_name = "Mouth" + mouth_num as String

mergeMAXfile (partdir + "Heads.max") #(head_name) #select
$.name = "Head"

mergeMAXfile (partdir + "Tentacles.max") #(tentacle_name) #select
$.name = "Tentacle"

mergeMAXfile (partdir + "Mouths.max") #(mouth_name) #select
$.name = "Mouth"

morph_weight_1 = float(hinfo[2])
morph_weight_2 = float(hinfo[3])
morph_weight_3 = float(hinfo[4])
morph_weight_4 = float(hinfo[5])

WM3_MC_SetValue $Head.morpher 1 morph_weight_1
WM3_MC_SetValue $Head.morpher 2 morph_weight_2
WM3_MC_SetValue $Head.morpher 3 morph_weight_3
WM3_MC_SetValue $Head.morpher 4 morph_weight_4

$Head.Noise1.seed = random 0 32000
$Head.Noise2.seed = random 0 32000

morph_weight_5 = float(tinfo[2])
morph_weight_6 = float(tinfo[3])

WM3_MC_SetValue $Tentacle.morpher 1 morph_weight_5
WM3_MC_SetValue $Tentacle.morpher 2 morph_weight_6

$Tentacle.Noise.seed = random 0 32000

$Mouth.Noise.seed = random 0 32000
)

fn creature2 hinfo tinfo minfo = 
(

partdir = "c:/stimuli/creatures/Family2/"

delete $Body
delete $Tentacle
delete $Mouth

body_num = hinfo[1]
tentacle_num = tinfo[1] 
mouth_num = minfo[1]

body_name = "Body" + body_num as String
tentacle_name = "Tentacle" + tentacle_num as String
mouth_name = "Mouth" + mouth_num as String

mergeMAXfile (partdir + "Bodies.max") #(body_name) #select
$.name = "Body"

mergeMAXfile (partdir + "Tentacles.max") #(tentacle_name) #select
$.name = "Tentacle"

mergeMAXfile (partdir + "Mouths.max") #(mouth_name) #select
$.name = "Mouth"

morph_weight_1 = float(hinfo[2])
morph_weight_2 = float(hinfo[3])
morph_weight_3 = float(hinfo[4])
morph_weight_4 = float(hinfo[5])

WM3_MC_SetValue $Body.morpher 1 morph_weight_1
WM3_MC_SetValue $Body.morpher 2 morph_weight_2
WM3_MC_SetValue $Body.morpher 3 morph_weight_3
WM3_MC_SetValue $Body.morpher 4 morph_weight_4

$Body.Noise1.seed = random 0 32000
$Body.Noise2.seed = random 0 32000

morph_weight_5 = float(tinfo[2])
morph_weight_6 = float(tinfo[3])

WM3_MC_SetValue $Tentacle.morpher 1 morph_weight_5
WM3_MC_SetValue $Tentacle.morpher 2 morph_weight_6

$Tentacle.Noise.seed = random 0 32000

$Mouth.Noise.seed = random 0 32000
)

fn creature3 hinfo tinfo minfo = 
(

partdir = "c:/stimuli/creatures/Family3/"

delete $Body
delete $Tentacle
delete $Mouth

body_num = hinfo[1]
tentacle_num = tinfo[1] 
mouth_num = minfo[1]

body_name = "Body" + body_num as String
tentacle_name = "Tentacle" + tentacle_num as String
mouth_name = "Mouth" + mouth_num as String

mergeMAXfile (partdir + "Bodies.max") #(body_name) #select
$.name = "Body"

mergeMAXfile (partdir + "Tentacles.max") #(tentacle_name) #select
$.name = "Tentacle"

mergeMAXfile (partdir + "Mouths.max") #(mouth_name) #select
$.name = "Mouth"

morph_weight_1 = float(hinfo[2])
morph_weight_2 = float(hinfo[3])
morph_weight_3 = float(hinfo[4])
morph_weight_4 = float(hinfo[5])

WM3_MC_SetValue $Body.morpher 1 morph_weight_1
WM3_MC_SetValue $Body.morpher 2 morph_weight_2
WM3_MC_SetValue $Body.morpher 3 morph_weight_3
WM3_MC_SetValue $Body.morpher 4 morph_weight_4

$Body.Noise1.seed = random 0 32000
$Body.Noise2.seed = random 0 32000

morph_weight_5 = float(tinfo[2])
morph_weight_6 = float(tinfo[3])

WM3_MC_SetValue $Tentacle.morpher 1 morph_weight_5
WM3_MC_SetValue $Tentacle.morpher 2 morph_weight_6

$Tentacle.Noise.seed = random 0 32000

$Mouth.Noise.seed = random 0 32000
)



fn create_and_render1 s f =
(
	heads = #( #(1,0,0,0,80), #(1,0,0,95,0),  #(1,0,80,0,0),  #(1,90,0,0,0), #(2,0,0,0,80), #(2,0,0,100,0),  #(2,0,100,0,0),  #(2,100,0,0,0), #(3,0,0,0,80), #(3,0,0,90,0),  #(3,0,70,0,0),  #(3,65,0,0,0), #(4,0,0,0,36), #(4,0,0,100,0), #(4,0,65,0,0), #(4,74,0,0,0))
  tentacles = #( #(1,0,65), #(1,60,0), #(2,0,40), #(2,45,0), #(2,0,45), #(2,50,0), #(3,0,45), #(3,40,0), #(3,0,45), #(3,45,0), #(4,0,45), #(4,50,0), #(4,0,55), #(4,50,0), #(1,0,60), #(1,60,0))

	m = #((random 1 8))
	creature1 heads[s] tentacles[s] m
	  
  	outdir = "c:/stimuli/creatures/max/family1/"
	saveMaxFile (outdir + f + ".max")
	  
--	outdir = "c:/stimuli/creatures/images/family1/png/"

--	r = 30
--	$Camera01.position = [0,-120,130]
	  
--	render camera:$Camera01 outputwidth:256 outputheight:256 outputFile:(outdir + f + ".jpg") vfb:false
)


fn create_and_render2 s f =
(
	heads = #( #(1,0,0,0,80), #(1,0,0,100,0),  #(1,0,70,0,0),  #(1,50,0,0,0), #(2,0,0,0,90), #(2,0,0,80,0),  #(2,0,90,0,0),  #(2,90,0,0,0), #(3,0,0,0,100), #(3,0,0,90,0),  #(3,0,80,0,0),  #(3,90,0,0,0), #(4,0,0,0,80), #(4,0,0,100,0), #(4,0,100,0,0), #(4,90,0,0,0))
  tentacles = #( #(1,0,70), #(1,80,0), #(2,0,30), #(2,30,0), #(2,0,30), #(2,30,0), #(3,0,30), #(3,30,0), #(3,0,30), #(3,30,0), #(4,0,30), #(4,30,0), #(4,0,30), #(4,30,0), #(1,0,30), #(1,30,0))

	m = #((random 1 8))
	creature2 heads[s] tentacles[s] m
	outdir = "c:/stimuli/creatures/max/family2/"
--	outdir = "c:/stimuli/creatures/images/family2/png/"

	r = 30
--	$Camera01.position = [-132.842,-90.5621,96.6781]+[(random -r r),(random -r r),(random -r r)]

--	render camera:$Camera01 outputwidth:512 outputheight:512 outputFile:(outdir + f + ".png") vfb:false
	saveMaxFile (outdir + f + ".max")
)

fn create_and_render3 s f =
(
	heads = #( #(1,0,0,0,65), #(1,0,0,90,0),  #(1,0,70,0,0),  #(1,70,0,0,0), #(2,0,0,0,90), #(2,0,0,80,0),  #(2,0,90,0,0),  #(2,90,0,0,0), #(3,0,0,0,100), #(3,0,0,90,0),  #(3,0,80,0,0),  #(3,90,0,0,0), #(4,0,0,0,80), #(4,0,0,100,0), #(4,0,100,0,0), #(4,90,0,0,0))
  tentacles = #( #(1,0,70), #(1,60,0), #(2,0,30), #(2,30,0), #(2,0,30), #(2,30,0), #(3,0,30), #(3,30,0), #(3,0,30), #(3,30,0), #(4,0,30), #(4,30,0), #(4,0,30), #(4,30,0), #(1,0,30), #(1,30,0))

	m = #((random 1 8))
	creature3 heads[s] tentacles[s] m
	outdir = "c:/stimuli/creatures/images/family3/jpg/"

	r = 25
--	$Camera01.position = [0,-140,160]

	render camera:$Camera01 outputwidth:256 outputheight:256 outputFile:(outdir + f + ".jpg") vfb:false
)

fn format_num x = 
(	
	valstr = int(x*1.) as string
	for i in 1 to 2-valstr.count do valstr = "0"+valstr
	return valstr
)


fn do_family1 = 
(
	species = #("a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p")
  for i in 1 to 16 do (
	  for j in 1 to 2 do (
		    create_and_render1 i ("a"+species[i]+(j as string))
        )
    )
)

fn do_family2 = 
(
	species = #("a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p")
  for i in 1 to 16 do (
	  for j in 1 to 16 do (
		    create_and_render2 i ("s"+species[i]+(j as string))
        )
    )
)

fn do_family3 = 
(
  species = #("a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p")
  for i in 1 to 16 do (
	  for j in 1 to 2 do (
		    create_and_render3 i ("h"+species[i]+(j as string))
        )
    )
)
