#
# FILE
#  Ephys_Seq_variants.tcl
# Ephys tasks for passive sequence viewing
# PROTOCOL
#   mri/Ephys_Seq
#
# DESCRIPTION
#   This file defines the specific variants displayed by stimgui, the loader proc
#     defined in {protocol}_loaders.tcl file, the shortname for default init and destroy
#     files, and the description displayed by stimgui.
#
# AUTHOR
#    based on shapes_and_saccades by HMS/DLS
#    3/24/16 TMD

namespace eval Ephys_Seq {
    # ---------------------------------------------------------------------
    # Variant Definitions
    # format { {display name} {loader proc}
    #          {shortname for defaults,init,destroy} {display description} }
    set variants {
	
	{ {jitter-pseq} jitter_pseq {jitter_pseq}\
	      {passive sequence viewing with jittered isi} }
	{ {habit-only} habit_only {habit_only}\
	      {habituation sequences all jittered itis} }
	{ {habit-only-doubled} habit_only_doubled {habit_only_doubled}\
	      {habituation sequences all jittered itis, 2 blocks} }
	{ {time-only} time_only {time_only}\
	      {pseq timing pattern with no image pattern} }
	{ {image-only} image_only {image_only}\
	      {only images} }
    }
    
    # ---------------------------------------------------------------------
    # Default init and destroy procs (copy and edit to make variant specific)
    proc default_init { } {
# 	::load image
#	::load metagroup
#	::load polygon
#	::load light
#	::load points
#	::load disk
#	::load shader

	package require stimctrl
	package require stimCompose

	init_vars

	shaderSetPath ../stimuli/shaders/
    }
    proc default_destroy { } {
	glistSetVisible 0; redraw; # !!! Must occur before unloading the font (to be fixed)
    }
    
    # ---------------------------------------------------------------------
    # Variant specific init and destroy procs (must occur as a set!)
    
    # ---------------------------------------------------------------------
    # Shared Procs

    proc init_vars {} {

        set ::mri::Ephys_Seq::event_index_in_run        0
        set ::mri::Ephys_Seq::event_index_needs_incr    0

        set ::mri::Ephys_Seq::onset_time_needs_logging  0
        set ::mri::Ephys_Seq::offset_time_needs_logging 0
        set ::mri::Ephys_Seq::verbose_logging           1
	# current_run was init to 1, should be 0 TMD 6/9/16
	set ::mri::Ephys_Seq::current_run               0
	set ::mri::Ephys_Seq::current_block             0
    }
} 
