# PROTOCOL
#   mri/Seq_scan
#   Protocols for scanning on passive sequence viewing that calls the tasks as they should be called with the proper image sets for scan day (humans/monkeys).
# DESCRIPTION
#   Define protocol localizers
#
# AUTHOR  
#   Based on shapes_and_saccades by HMS/DLS
#   3/24/16 TMD

namespace eval Ephys_Seq {
   proc prot_init { } {
       # just get the stimcmds ready
       stimcmds
   }
   proc prot_destroy { } {
       # nothing to do for now
   }

   proc describe {} {
       return "Objects and space"
   }

   proc stimcmds {} {
       namespace inscope :: {
           proc reset { } {
	       dout .....00.
               glistSetVisible 0; redraw;
	       ::mri::Ephys_Seq::init_vars
           }

	   proc fixon {} {
	       set fixblock [dl_length [dl_unique stimdg:block_n]]
               glistSetCurGroup $fixblock; glistSetVisible 1; redraw;
	   }

           proc show { id } {
               glistSetCurGroup $id; glistSetVisible 1; redraw;
               ::mri::Ephys_Seq::d_hi
           }

           proc clearscreen { } {
               glistSetVisible 0; redraw;
               ::mri::Ephys_Seq::d_lo
           }

	   # Will be called before the first run.
	   # Shown until trigger start.
	   proc presession { } {

	       # Current run is a global variable and lives outside this
	       # proc. It is set in the variants file.
	       set current_run $::mri::Ephys_Seq::current_run 
	       set first_run_index [dl_first [dl_findAll stimdg:block_n $current_run]]

	       set run_type [dl_get stimdg:block_type $first_run_index]

	       # Assumes that the background does not change within the run
	       set background_luminance [dl_get stimdg:background_luminance $first_run_index]
	       setBackground $background_luminance $background_luminance $background_luminance
	       # No need to wait - 0 means no timer until nextrun
	       return 0
	   }

           proc nextrun { } {
	       global fixspot saccspot

	       # assume load image called by default_init (variants)

               # Items that might be useful from old code:
	       #::mri::localizers::d_lo
               #set ::mri::localizers::status -1
	       # Current run is a global variable and lives outside this
	       # proc. It is set in the variants file.
	       #set current_run $::mri::localizers::current_run 
	       # Fixation disk that stays on for the entire time
	       #set middle_fix_handle [::mri::localizers::add_fix]

	       # assume stimdg exists as a global

	       # Prep for the trial(run) - reset lists
	       resetObjList
	       #	       imgreset
	       shaderImageReset
	       shaderDeleteAll

	       # This is initialized in _variants but set it to the first block here
	       set ::mri::Ephys_Seq::current_block 0

	       # fixation point (from seq.tcl)
	       set fixspot [polygon]
	       # diamond from seq.tcl
	       #polyverts $fixspot "-.7 0 .7 0" "0 .7 0 -.7"
	       #polycolor $fixspot 1.0 .75 0
	       # square from prf/survey2.tcl
	       polyverts $fixspot "-.5 -.5 .5 .5 -.5" "-.5 .5 .5 -.5 -.5"
	       polycolor $fixspot .75 .75 0
	       scaleObj $fixspot .3

	       # saccade spot - make it the same as fixspot
	       # Want a copy of it because want to move it around
	       set saccspot [polygon]
	       polyverts $saccspot "-.5 -.5 .5 .5" "-.5 .5 .5 -.5"
	       polycolor $saccspot .75 .75 0
	       scaleObj $saccspot .3

	       # time he's given to reacquire spot after it moves
	       set r_time 300

	       # polar wedge (from testshader.tcl)
	       set s [shaderBuild polar_wedge]
	       set shadeobj [shaderObj $s]

	       shaderObjSetUniform $shadeobj NRings 15.0
	       shaderObjSetUniform $shadeobj WedgeSize .25
	       shaderObjSetUniform $shadeobj CycleTime 32.
	       shaderObjSetUniform $shadeobj NSpokes 24.
	       shaderObjSetUniform $shadeobj StimSize 12.
	       shaderObjSetUniform $shadeobj HoleSize 0.
	       scaleObj $shadeobj 10.0
	       #translateObj $obj -4 -4

	       # ************
	       # Image Blocks
	       # ************
	       
	       # find the non-fixation, non-shaders, non-saccade lines
	       dl_local imgIdxs [dl_indices \
				     [dl_not [dl_oneof stimdg:block_type \
						  [dl_slist fixation shaders saccade]]]]

	       # Testing
	       # -------
	       #dl_local imgList [dl_choose stimdg:stimuli $imgIdxs]
	       # Dumb loop that goes through each image and loads it <<Haha who wrote this?
	       #foreach imgPath [dl_tcllist $imgList] {
	       #shaderImageLoad $imgPath
	       #}

	       # figure out how many non-fixation blocks there are in stimdg
	       dl_local uqImgBlocks [dl_unique [dl_choose stimdg:block_n $imgIdxs]]
	       set nImgBlocks [dl_llength $uqImgBlocks]

	       # Initialize the glist that will hold them all
	       #glistInit $nImgBlocks ;# indexs 0 to nImgBlocks-1
	       # Initialize all groups, not just image ones, becuase want the
	       #  img group to match the block number
	       # We add one at the end to show fixpost alone for pre_trigger fix

	       glistInit [expr [dl_llength [dl_unique stimdg:block_n]]+1]

	       # This loop creates a glist for every block
	       #  Set the first frame of every block to zero so that the groups can
	       #  be shown independently (not like listed in stimdg, which would assume
	       #  they are all one big group

	       #
	       # Before we starting loading images, we find out how many unique ones
	       #  are in the list, and only read those from disk using shaderImageLoad.  Then
	       #  we can refer to the loaded image index for each stimulus which means
	       #  we can reuse the actual loaded images many times without loading
	       #  repeats
	       #
	       dl_local uqImgFiles [dl_unique [dl_choose stimdg:stimuli $imgIdxs]]
	       foreach imgFile [dl_tcllist $uqImgFiles] {
		   set imgFileIds($imgFile) [shaderImageLoad $imgFile]
	       }

	       set img_shader [shaderBuild image]
	       set null [nullObj]
	       
	       foreach block_n [dl_tcllist $uqImgBlocks] {

		   dl_local blockIdxs [dl_findAll [dl_eq stimdg:block_n $block_n] 1]
	
		   # First frame of the block
		   set firstBlockFrameN [dl_get stimdg:onFrameN \
					     [dl_get $blockIdxs 0]]
		   #			  [lindex [dl_tcllist $blockIdxs] 0]]

		   foreach blockLine [dl_tcllist $blockIdxs] {

		       # If the fixation spot is present, add that to the list
		       set fixPresent [dl_get stimdg:fixPresent $blockLine]

		       # load the image and make the pointer to it
		       # use reference to already shaderImageLoad'd imgFileId from above
		       set img_id [shaderImageID $imgFileIds([dl_get stimdg:stimuli $blockLine])]
		       set img [shaderObj $img_shader]
		       shaderObjSetSampler $img $img_id 0

		       # if want to scale or move object, can do here
		       # translateObj
		       # floating as an input
		       scaleObj $img 5.0
	    
		       # Put the pointer in as many times as needed
		       # First frame zero and rest in ref to that
		       set onFrameN [expr [dl_get stimdg:onFrameN $blockLine] \
					 - $firstBlockFrameN]
		       # offFrameN should be treated as the frame the obj turns off
		       set offFrameN [expr [dl_get stimdg:offFrameN $blockLine] \
					  - $firstBlockFrameN]
		       set endFrameN [expr [dl_get stimdg:endFrameN $blockLine] \
					  - $firstBlockFrameN]
	    
		       # Add as many pointers as frames
		       # Note, does not include the last frame
		       for { set i $onFrameN } { $i < [expr $offFrameN-1] } { incr  i } {
			   glistAddObject $img $block_n $i 
			   if { $fixPresent } { glistAddObject $fixspot $block_n $i }
		       }

		       # Add the off time
		       for { set i $offFrameN } { $i < [expr $endFrameN-1] } { incr  i } {
			   glistAddObject $null $block_n $i
			   if { $fixPresent } { glistAddObject $fixspot $block_n $i }
		       }

		       glistSetFrameInitCmd "move_fix 0 0 0" $block_n $onFrameN
		   }
		   # Make them dynamic (type "1", which moves through every frame)
		   glistSetDynamic $block_n 1
		   glistSetRepeatMode $block_n oneshot
	       } ;# end foreach block_n

	       # **************
	       # Shaders blocks (retinotopy)
	       # **************

	       # find the shaders lines
	       dl_local shadeIdxs [dl_findAll [dl_eq stimdg:block_type "shaders"] 1]
	       dl_local uqShadeBlocks [dl_unique [dl_choose stimdg:block_n $shadeIdxs]]

	       foreach block_n [dl_tcllist $uqShadeBlocks] {
		   dl_local blockIdxs [dl_findAll [dl_eq stimdg:block_n $block_n] 1]
	
		   # First frame of the block
		   set firstBlockFrameN [dl_get stimdg:onFrameN \
					     [dl_get $blockIdxs 0]]

		   foreach blockLine [dl_tcllist $blockIdxs] {
		       # Put the pointer in as many times as needed
		       # First frame zero and rest in ref to that
		       set onFrameN [expr [dl_get stimdg:onFrameN $blockLine] \
					 - $firstBlockFrameN]
		       # offFrameN should be treated as the frame the obj turns off
		       set offFrameN [expr [dl_get stimdg:offFrameN $blockLine] \
					  - $firstBlockFrameN]
		       set endFrameN [expr [dl_get stimdg:endFrameN $blockLine] \
					  - $firstBlockFrameN]

		       # Add as many pointers as frames for shader
		       # Note, does not include the last frame
		       for { set i $onFrameN } { $i < [expr $offFrameN-1] } { incr  i } {
			   glistAddObject $shadeobj $block_n $i 
		       }
		       
		       # If the fixation spot is present, add that to the list
		       set fixPresent [dl_get stimdg:fixPresent $blockLine]
		       if {$fixPresent == 1} {
			   for { set i $onFrameN } { $i < [expr $endFrameN-1] } { incr i } {
			       glistAddObject $fixspot $block_n $i
			   }
		       }
		       glistSetFrameInitCmd "move_fix 0 0 0" $block_n $onFrameN
		   }
		   # Make them dynamic (type "1", which moves through every frame)
		   glistSetDynamic $block_n 1
		   glistSetRepeatMode $block_n oneshot
	       } ;# end foreach block_n (shaders)

	       # ***************
	       # Fixation blocks
	       # ***************

	       # find the fixation lines
	       dl_local fixIdxs [dl_findAll [dl_eq stimdg:block_type "fixation"] 1]
	       dl_local uqFixBlocks [dl_unique [dl_choose stimdg:block_n $fixIdxs]]

	       foreach block_n [dl_tcllist $uqFixBlocks] {
		   dl_local blockIdxs [dl_findAll [dl_eq stimdg:block_n $block_n] 1]
	
		   # First frame of the block
		   set firstBlockFrameN [dl_get stimdg:onFrameN \
					     [dl_get $blockIdxs 0]]

		   foreach blockLine [dl_tcllist $blockIdxs] {
		       # Put the pointer in as many times as needed
		       # First frame zero and rest in ref to that
		       set onFrameN [expr [dl_get stimdg:onFrameN $blockLine] \
					 - $firstBlockFrameN]
		       # offFrameN should be treated as the frame the obj turns off
		       set offFrameN [expr [dl_get stimdg:offFrameN $blockLine] \
					  - $firstBlockFrameN]
		       set endFrameN [expr [dl_get stimdg:endFrameN $blockLine] \
					  - $firstBlockFrameN]
		       
		       # If the fixation spot is present, add that to the list
		       set fixPresent [dl_get stimdg:fixPresent $blockLine]
		       if {$fixPresent == 1} {
			   for { set i $onFrameN } { $i < [expr $endFrameN-1] } { incr i } {
			       glistAddObject $fixspot $block_n $i
			   }
		       }
		       glistSetFrameInitCmd "move_fix 0 0 0" $block_n $onFrameN

		   }
		   # Make them dynamic (type "1", which moves through every frame)
		   glistSetDynamic $block_n 1
		   glistSetRepeatMode $block_n oneshot
	       } ;# end foreach block_n (fixation)


	       # **************
	       # Saccade blocks
	       # **************

	       # find the saccade lines
	       dl_local saccIdxs [dl_findAll [dl_eq stimdg:block_type "saccade"] 1]
	       dl_local uqSaccBlocks [dl_unique [dl_choose stimdg:block_n $saccIdxs]]

	       foreach block_n [dl_tcllist $uqSaccBlocks] {
		   dl_local blockIdxs [dl_findAll [dl_eq stimdg:block_n $block_n] 1]
	
		   # First frame of the block
		   set firstBlockFrameN [dl_get stimdg:onFrameN \
					     [dl_get $blockIdxs 0]]

		   foreach blockLine [dl_tcllist $blockIdxs] {
		       # Put the pointer in as many times as needed
		       # First frame zero and rest in ref to that
		       set onFrameN [expr [dl_get stimdg:onFrameN $blockLine] \
					 - $firstBlockFrameN]
		       # offFrameN should be treated as the frame the obj turns off
		       set offFrameN [expr [dl_get stimdg:offFrameN $blockLine] \
					  - $firstBlockFrameN]
		       set endFrameN [expr [dl_get stimdg:endFrameN $blockLine] \
					  - $firstBlockFrameN]
		       
		       # If the fixation spot is present, add that to the list
		       # For this one actually Ignore fixPresent because don't want the
		       #    saccade and the fixation spot on at the same time
		       #set fixPresent [dl_get stimdg:fixPresent $blockLine]
		       #if {$fixPresent == 1} {

		       for { set i $onFrameN } { $i < [expr $endFrameN-1] } { incr i } {
			   glistAddObject $saccspot $block_n $i
		       }

		       # Set the location of the saccade spot
		       set x [dl_get stimdg:stimloc_x $blockLine]
		       set y [dl_get stimdg:stimloc_y $blockLine]
		       glistSetFrameInitCmd \
			   "translateObj $saccspot $x $y; move_fix $x $y $r_time" \
			   $block_n $onFrameN

		       #}
		   }
		   # Make them dynamic (type "1", which moves through every frame)
		   glistSetDynamic $block_n 1
		   glistSetRepeatMode $block_n oneshot
	       } ;# end foreach block_n (saccade)

	       set n_blocks [dl_length [dl_unique stimdg:block_n]]
	       # Now add fixspot to last group for trigger_wait period
	       glistAddObject $fixspot $n_blocks

	       # Ensure color changes appear
	       glistSetDynamic $n_blocks 1

	       return $n_blocks
	   } ;#end proc nextrun
	   
	   proc nextblock { } {

	       show $::mri::Ephys_Seq::current_block

	       #increment the block
	       set ::mri::Ephys_Seq::current_block [expr $::mri::Ephys_Seq::current_block+1]

	   } ;#end proc nextblock

	   proc block_times {} {
	       # Time, in seconds, that each block starts - may want as global
	       dl_local block_times \
		   [dl_mins [dl_sortByList stimdg:onSec stimdg:block_n]]
	       set ::mri::Ephys_Seq::block_times [dl_tcllist $block_times]
	       lappend ::mri::Ephys_Seq::block_times \
		   [dl_get stimdg:offSec [expr [dl_length stimdg:offSec]-1]]
	       return $::mri::Ephys_Seq::block_times
	   }

	   proc rewardinfo {} {
	       # Parameters necessary for the reward in the state system
	       # Start with max, every n rewards subtract the inc from the time down to the min
	       # Note that right now these are not different per trial, so could use the below,
	       #   but want to maintain the capability of changin it trial by trial
	       #return [dl_first stimdg:rewardDuration]

	       # Find the first line in stimdg that is the current block
	       set blockIdx [dl_find [dl_eq stimdg:block_n $::mri::Ephys_Seq::current_block] 1]

	       # Get the 4 reward parameters from stimdg for this block
	       set rwdInt_max [dl_get stimdg:rwdInt_max $blockIdx]
	       set rwdInt_min [dl_get stimdg:rwdInt_min $blockIdx]
	       set rwdInt_inc [dl_get stimdg:rwdInt_inc $blockIdx]
	       set rwdInt_n [dl_get stimdg:rwdInt_n $blockIdx]

	       # Send those 4 values
	       return "$rwdInt_max $rwdInt_min $rwdInt_inc $rwdInt_n"
	   }

	   proc fixate_in {} { 
	       change_fix_color 1;
	       # could check for this, but should always be true
	       #  if { ![glistOneShotActive] } { redraw }	       
	   }

	   proc fixate_out {} { 
	       change_fix_color 0;
	       # could check for this, but should always be true
	       #  if { ![glistOneShotActive] } { redraw }	       
	   }

	   proc change_fix_color { fixstate } {
	       
	       if { $fixstate == 0 } {
		   # Not fixating
		   polycolor $::fixspot .75 0 0
		   polycolor $::saccspot .75 0 0
	       } else {
		   # Fixating, set back to original color
		   polycolor $::fixspot .75 .75 0
		   polycolor $::saccspot .75 .75 0
	       }

	   } ;#end proc change_fix_color

	   
	   # Simulate MRI hardware trigger by sending message to dataserver
	   # command is "trigger"
	   proc trigger {} {
	       global env
	       set host 192.168.0.150
	       if { $env(COMPUTERNAME)=="MRISTIM" ||
	            $env(COMPUTERNAME)=="FMRISTIM" ||
	            $env(COMPUTERNAME)=="FMRI-STIM" } {
		   ess_send $host "stim_request=trigger"

	       } elseif { $env(COMPUTERNAME)=="stim" } {
		   qpcs::dsSet 100.0.0.40 stim_request trigger
	       }
	   }

	   proc move_fix { x y time } {
	       global env
	       set host 192.168.0.150
	       if { $env(COMPUTERNAME)=="MRISTIM" ||
	            $env(COMPUTERNAME)=="FMRI-STIM" ||
	            $env(COMPUTERNAME)=="FMRISTIM" } {
#		   ess_send $host "stim_request=fixmove 0 $x $y 6.0 $time"
		   dout ......!. 
	       }
	   }

	   proc endobs {} {
	       clearscreen
	   }
	   
	   # This proc needs more changing (old note)
           proc endrun { } {
	       set n_runs 1
	       set ::mri::Ephys_Seq::current_run 1
	       set ::mri::Ephys_Seq::slot_index_in_run 0

	       # Also clear screen in state system
	       clearscreen

               return "$n_runs $::mri::Ephys_Seq::current_run"
           }
	   
	   proc postrun { } {
	       
	       set instructions_on_for 1000
	       resetObjList
	       glistInit 1

	       # The endrun proc will already have incremented the current run.
	       set runs_down [expr $::mri::Ephys_Seq::current_run - 1]
	       set n_runs [dl_get stimdg:n_runs 0]
	       set runs_to_go [expr $n_runs - $runs_down]

	       set instructions "Please remain still."
	       set text_starting_position 4.0
	       set text_group [::mri::Ephys_Seq::create_text $instructions $text_starting_position]
	       glistAddObject $text_group 0

	       glistSetCurGroup 0
	       glistSetVisible 1
	       redraw
	       
	       return $instructions_on_for
	   }
	   
	   proc closedata { } {
	       # special closedata which reloads the variant to get new trials
	       set ::datafile_open 0
	       eval $::current(lastloadcmd)
	       newstimdg
	   }

	   proc test_proc { } {
	       ::mri::Ephys_Seq::prettify_stims
	   }

       }
   }

    proc add_fix { } {

# Was like this in first pilot
# 	set fix [disk 0]
# 	diskcolor $fix 1 1 1
# 	diskradii $fix 0.0 0.05
# 	diskparams $fix 20 40

	set fix_outer [disk 0]
	diskcolor $fix_outer 0 0 0
	diskradii $fix_outer 0.12 0.15
	diskparams $fix_outer 20 40

	set fix_middle [disk 0]
	diskcolor $fix_middle  1 1 1
	diskradii $fix_middle  0.01 0.12
	diskparams $fix_middle  20 40

	set fix_inner [disk 0]
	diskcolor $fix_inner  0 0 0
	diskradii $fix_inner  0.0 0.01
	diskparams $fix_inner  20 40

	glistAddObject $fix_inner 0
	glistAddObject $fix_middle 0
	glistAddObject $fix_outer 0

	return $fix_middle
    }

    proc makegaussian { size sigma_pixels } {
	dl_local g [dl_gaussian2D $size $size $sigma_pixels]
	set gaussian [imgcreate $g $size $size linear alpha]
    }

    proc add_disk_target { disk_target_radius } {

	set disk_target [disk 0]
	diskcolor $disk_target 1 1 1
	diskradii $disk_target 0.0 $disk_target_radius
	diskparams $disk_target 20 40

	setVisible $disk_target 1

        setObjProp $disk_target in_jump_sequence 0
	setObjProp $disk_target curr_location_012 0

	glistAddObject $disk_target 0

	return $disk_target

    }
    

    proc create_text { text ypos text_luminance} {
	set mg [metagroup]
	
	# ypos is the starting vertical position in degrees
	set yincr 1.25;		# How much to move down for each line
	textCenter 1
	foreach line [split $text \n] {
	    set text [textObj]
	    metagroupAdd $mg $text
	    textFont $text $::mri::Ephys_Seq::fontID
	    textColor $text $text_luminance $text_luminance $text_luminance
	    textString $text $line
	    scaleObj $text .5
	    translateObj $text 0 $ypos
	    set ypos [expr $ypos-$yincr]
	}
	return $mg
    }

    proc disk_jump { disk_target_handle times_in times_out first_saccade_translation second_saccade_translation last_run_index } {

       set frame_dur [screen_set FrameDuration]

	if { [run_is_over_check $last_run_index] == 1 } { return }

	set curr_event_i $::mri::Ephys_Seq::event_index_in_run

        set curr_times_in              [dl_get $times_in $curr_event_i]
	set curr_times_out             [dl_get $times_out $curr_event_i]

        # I am correcting these times for the frame rate
        set curr_times_in              [dl_sub $curr_times_in [expr round(($frame_dur / 2.0) + $frame_dur)]]
        set curr_times_out             [dl_sub $curr_times_out [expr round(($frame_dur / 2.0) + $frame_dur)]]

       set curr_shape_name [dl_get stimdg:shape_name $curr_event_i]
       set is_null_event [dl_first [dl_eq $curr_shape_name [dl_slist "null"]]]
       if { $is_null_event } {
	   set curr_first_time_in [dl_get $curr_times_in 0]
	   if { $::StimTime >= $curr_first_time_in } {
	       set curr_third_time_out [dl_get $curr_times_out 2]

	       # This is an ugly fix, but the next jump is consistently 
	       # around one frame too late, so I am going to update the
	       # event index at an earlier time
	       if { $::StimTime < [expr round($curr_third_time_out - $frame_dur)] } {
		   if { $::mri::Ephys_Seq::event_index_needs_incr == 0 } {
		       set ::mri::Ephys_Seq::event_index_needs_incr 1
		       set ::mri::Ephys_Seq::onset_time_needs_logging 1		       
		   }
	       } else {
		   incr ::mri::Ephys_Seq::event_index_in_run
		   set ::mri::Ephys_Seq::event_index_needs_incr 0  
		   set ::mri::Ephys_Seq::offset_time_needs_logging 1
	       }
	   }
       } else {

	   set event_index_needs_incr   $::mri::Ephys_Seq::event_index_needs_incr
	   
	   # 0 is center, 1 is location of first saccade, 2 is location of second saccade

	   if { [setObjProp $disk_target_handle curr_location_012] == 0 } {
	       set curr_first_time_out        [dl_get $curr_times_out 0]	   
	       set curr_third_time_out        [dl_get $curr_times_out 2] 

	       if { [setObjProp $disk_target_handle in_jump_sequence] == 0 } {

		   if { [expr $::StimTime < $curr_first_time_out] } { 

		       # If this is the first time we enter this loop after the time has 
		       # reached the current time in, then mark that the real onset time
		       # needs logging. Also, next time a stimulus is turned off, the index
		       # will be incremented.
		       if { $::mri::Ephys_Seq::event_index_needs_incr == 0 } {
			   set ::mri::Ephys_Seq::event_index_needs_incr 1
			   set ::mri::Ephys_Seq::onset_time_needs_logging 1

		       } else {
			   set ::mri::Ephys_Seq::onset_time_needs_logging 0
		       }

		       translateObj $disk_target_handle [dl_get $first_saccade_translation $curr_event_i]  0.0
		       setObjProp $disk_target_handle curr_location_012 1

		       setVisible $disk_target_handle 1

		       setObjProp $disk_target_handle in_jump_sequence 1	

		       # This is an ugly fix, but the next jump is consistently 
		       # around one frame too late, so I am going to update the
		       # event index at an earlier time
		   } elseif { [expr $::StimTime >= (round($curr_third_time_out - $frame_dur))] } {

		       incr ::mri::Ephys_Seq::event_index_in_run
		       set ::Ephys_Seq::event_index_needs_incr 0
		   }
	       }
	   } elseif { [setObjProp $disk_target_handle curr_location_012] == 1 } {

	       set curr_first_time_out        [dl_get $curr_times_out 0]	 


	       if { $::StimTime >= $curr_first_time_out } {

		   set curr_second_time_in        [dl_get $curr_times_in 1]

		   if { $::StimTime > $curr_second_time_in } {

		       translateObj $disk_target_handle [expr [dl_get $first_saccade_translation $curr_event_i] + [dl_get $second_saccade_translation $curr_event_i]]  0.0
		       setObjProp $disk_target_handle curr_location_012 2

		       setVisible $disk_target_handle 1

		   } else {
		       setVisible $disk_target_handle 0

		   }	
	       }
	   } else {
	       set curr_second_time_out       [dl_get $curr_times_out 1]

	       if { $::StimTime >= $curr_second_time_out } {

		   set curr_third_time_in         [dl_get $curr_times_in 2]

		   if { $::StimTime >= $curr_third_time_in } {

		       # This will only happen once after the spot has jumped back to center 
		       set ::mri::Ephys_Seq::offset_time_needs_logging 1

		       translateObj $disk_target_handle 0.0  0.0
		       setObjProp $disk_target_handle curr_location_012 0

		       setVisible $disk_target_handle 1
		       setObjProp $disk_target_handle in_jump_sequence 0
		   } else {
		       setVisible $disk_target_handle 0
		       setObjProp $disk_target_handle is_on 0
		   }	
	       }
	   } 

       }
   }

       # This one was written by Heida
    proc change_fix_color_old { middle_fix_handle } {
	set color_change_time_i [setObjProp $middle_fix_handle color_change_time_i]
	if { $color_change_time_i == [dl_length stimdg:color_change_time] } {
	    set color_change_ontime 999999999
	} else {
	    set color_change_ontime [dl_get stimdg:color_change_time $color_change_time_i]
	}
	if { $::StimTime > $color_change_ontime } {

	    set color_change_r [dl_get stimdg:color_change_r $color_change_time_i]
	    set color_change_g [dl_get stimdg:color_change_g $color_change_time_i]
	    set color_change_b [dl_get stimdg:color_change_b $color_change_time_i]

	    diskcolor $middle_fix_handle $color_change_r $color_change_g $color_change_b 1.0
	    
	    setObjProp $middle_fix_handle color_change_time_i [expr $color_change_time_i + 1]

	    setObjProp $middle_fix_handle color_change_offtime [expr $color_change_ontime + [dl_get stimdg:color_duration $color_change_time_i]]
	} elseif { $::StimTime > [setObjProp $middle_fix_handle color_change_offtime] } {
	    diskcolor $middle_fix_handle 1.0 1.0 1.0 1.0
	} else {
	    return
	}
    }

    proc show_images { null_handle stim_handles times_in times_out last_run_index } {

        set frame_dur [screen_set FrameDuration]

	if { [run_is_over_check $last_run_index] == 1 } { return }

	set curr_event_i $::mri::Ephys_Seq::event_index_in_run

	set curr_stim_handle [dl_get $stim_handles $curr_event_i]

        set curr_time_in            [dl_get $times_in $curr_event_i]
	set curr_time_out           [dl_get $times_out $curr_event_i]

	set curr_time_in_frame_dur_corrected [expr $curr_time_in - [expr round($frame_dur / 2.0) + $frame_dur]]
	set curr_time_out_frame_dur_corrected [expr $curr_time_out - [expr round($frame_dur / 2.0) + $frame_dur]]

        set event_index_needs_incr   $::mri::Ephys_Seq::event_index_needs_incr

	set is_null_event [expr $curr_stim_handle == $null_handle]
	if { $is_null_event } {
	    if { $::StimTime >= $curr_time_in_frame_dur_corrected } {
		# This is an ugly fix, but the next jump is consistently 
		# around one frame too late, so I am going to update the
		# event index at an earlier time
		if { $::StimTime < [expr round($curr_time_out_frame_dur_corrected - $frame_dur)] } {
		    if { $::mri::Ephys_Seq::event_index_needs_incr == 0 } {
			set ::mri::Ephys_Seq::event_index_needs_incr 1
			set ::mri::Ephys_Seq::onset_time_needs_logging 1		       
		    }
		} else {
		    incr ::mri::Ephys_Seq::event_index_in_run
		    set ::mri::Ephys_Seq::event_index_needs_incr 0  
		    set ::mri::Ephys_Seq::offset_time_needs_logging 1
		}
	    }
	} else {


	    # If the onset time is up, update the object and show it
	    if { $::StimTime >= $curr_time_in_frame_dur_corrected } {

		# If the offset time is up, turn the object off and update the index to
		# for the next stimulus
		if { $::StimTime < $curr_time_out_frame_dur_corrected } {

		    # If this is the first time we enter this loop after the time has 
		    # reached the current time in, then mark that the real onset time
		    # needs logging. Also, next time a stimulus is turned off, the index
		    # will be incremented.
		    if { $::mri::Ephys_Seq::event_index_needs_incr == 0 } {
			set ::mri::Ephys_Seq::event_index_needs_incr 1
			set ::mri::Ephys_Seq::onset_time_needs_logging 1

		    } else {
			set ::mri::Ephys_Seq::onset_time_needs_logging 0
		    }

		    setVisible $curr_stim_handle  1
		} else {
		    setVisible $curr_stim_handle  0
		    
		    if { $event_index_needs_incr } {
			# This will only happen once after the image has 
			# been turned off. 
			incr ::mri::Ephys_Seq::event_index_in_run
			set ::mri::Ephys_Seq::event_index_needs_incr 0
			set ::mri::Ephys_Seq::offset_time_needs_logging 1

			# I am adding this for the cases where the onset of one stimulus 
			# happens exactly at the offset of another stimulus. If this is
			# not added, then there will be one frame in between these events.
			# This should only happen when there IS actually an event after the
			# offset of another one, so it should not happen for the last stimulus
			# in a run.
			if { $curr_event_i < $last_run_index } {
			    set next_time_in [dl_get $times_in [expr 1 + $curr_event_i]]
			    if { $curr_time_out == $next_time_in } { 

				set ::mri::Ephys_Seq::event_index_needs_incr 1
				set ::mri::Ephys_Seq::onset_time_needs_logging 1

			    }
			}
		    }
		    set ::mri::Ephys_Seq::time_just_exceeded_onset 1 
		}
	    } else {
		setVisible $curr_stim_handle 0
	    }  

	}
    }

    proc show_continous_images { middle_fix_handle null_handle stim_handles times_in times_out last_run_index } {

       set frame_dur [screen_set FrameDuration]

       if { [run_is_over_check $last_run_index] == 1 } { return }

       set curr_event_i $::mri::Ephys_Seq::event_index_in_run

       set curr_stim_handle [dl_get $stim_handles $curr_event_i]

        set curr_time_in           [dl_get $times_in $curr_event_i]
	set curr_time_out          [dl_get $times_out $curr_event_i]

	set curr_time_in_frame_dur_corrected [expr $curr_time_in - [expr round($frame_dur / 2.0)]]
	set curr_time_out_frame_dur_corrected [expr $curr_time_out - [expr round($frame_dur / 2.0)]]

       set event_index_needs_incr   $::mri::Ephys_Seq::event_index_needs_incr

       set curr_is_null_event [expr $curr_stim_handle == $null_handle]

       if { $::StimTime >= $curr_time_in_frame_dur_corrected } {

	   if { $::StimTime >= $curr_time_out_frame_dur_corrected } {

	       if { [setObjProp $curr_stim_handle is_visible] == "yes" } {

		   set ::mri::Ephys_Seq::offset_time_needs_logging 1
		   setVisible $curr_stim_handle 0
		   setObjProp $curr_stim_handle is_visible no

		   set ::mri::Ephys_Seq::event_index_needs_incr 1
	       }
	       
	   } else {

	       if { [setObjProp $curr_stim_handle is_visible] == "no" } {

		   set ::mri::Ephys_Seq::onset_time_needs_logging 1
		   setVisible $curr_stim_handle 1
		   setObjProp $curr_stim_handle is_visible yes

		   set ::mri::Ephys_Seq::time_just_exceeded_onset 1 

	       }

	   }
       } 

       if { $event_index_needs_incr } {
	   # This will only happen once after the image has 
	   # been turned off. 
	   incr ::mri::Ephys_Seq::event_index_in_run
	   set ::mri::Ephys_Seq::event_index_needs_incr 0

       }

       change_fix_color $middle_fix_handle
    }

    proc prepare_shape { curr_event_i } {

	dl_local shape_polygon [dl_get stimdg:unflipped_polygon $curr_event_i]
	set flip_shape [dl_get stimdg:flip_shape $curr_event_i]
	if { $flip_shape } {
	    dl_local shape_polygon [reflect_verts $shape_polygon 1]
	}

	dl_local shape_poly_x $shape_polygon:0
	dl_local shape_poly_y $shape_polygon:1

	set r 255
	set g 255
	set b 255

	set width 512; set width_2 [expr $width/2]
	set height 512; set height_2 [expr $height/2]
	set depth 4

	set shape_x $shape_poly_x
	set shape_y $shape_poly_y
	
	dl_local xscaled [dl_add [dl_mult $shape_x $width] $width_2]
	dl_local yscaled [dl_add [dl_mult [dl_negate $shape_y] $height] $height_2]

	set img [img_create -width $width -height $height -depth $depth]
	set poly [img_fillPolygonOutside $img $xscaled $yscaled $r $g $b 255]
	img_invert $poly
	dl_local pix [img_img2list $poly]
	set stim_handle [img [imgcreate $pix $width $height linear]]

	img_delete $img $poly

	# Various object properties     
	set stim_scale [dl_get stimdg:stim_scale $curr_event_i]
	scaleObj $stim_handle $stim_scale

	glistAddObject $stim_handle 0
	setVisible $stim_handle 0

	return $stim_handle

    }

    proc prepare_stim { stim_dir stim_scaling_factor } {

	set gaussian_size 450;
	set sigma_pixels 120; # might want this to be a variable
	set mask_handle [img [makegaussian $gaussian_size $sigma_pixels]]
	scaleObj $mask_handle $stim_scaling_factor

	set img_handle [img [imgload $stim_dir]]
	imgforcealpha $img_handle 0; # allow alpha of gaussian to blend
	scaleObj $img_handle $stim_scaling_factor

	glistAddObject $mask_handle 0
	glistAddObject $img_handle 0
	setVisible $img_handle 0

	setObjProp $img_handle is_visible no

	return $img_handle

    }

    proc reflect_verts { verts axis } {
	if { $axis == 0 } {
	    dl_return [dl_llist $verts:0 [dl_negate $verts:1]]
	} else {
	    dl_return [dl_llist [dl_negate $verts:0] $verts:1]
	}
    }

    proc change_color { image_handle color_list_for_run times_in times_out} {

       if { [run_is_over_check] == 1 } { return }

       # ::mri::N_localizers::slot_index_in_run is initialized in the variants file

       set curr_time_in  [dl_get $times_in $::mri::Ephys_Seq::slot_index_in_run]
       set curr_time_out [dl_get $times_out $::mri::Ephys_Seq::slot_index_in_run]

       # Get the color for the current stimulus slot
       set curr_color_code [dl_get $color_list_for_run $::mri::Ephys_Seq::slot_index_in_run]
       set GREY 0
       set GREEN 1
       set RED -1

       dl_local GREY_RGB  [dl_tcllist [dl_flist 0.5 0.5 0.5 ]]
       dl_local GREEN_RGB [dl_tcllist [dl_flist 0.0 0.8 0.0 ]]
       dl_local RED_RGB   [dl_tcllist [dl_flist 0.8 0.0 0.0 ]] 

       if { $curr_color_code == $GREY } {
	   set curr_RGB_list $GREY_RGB
       } elseif { $curr_color_code == $GREEN } {
	   set curr_RGB_list $GREEN_RGB
       } elseif { $curr_color_code == $RED } {
	   set curr_RGB_list $RED_RGB
       } else {
	   puts "unknown color code"
       }

       # Get current RGB values
       set r_color [dl_get $curr_RGB_list 0]
       set g_color [dl_get $curr_RGB_list 1]
       set b_color [dl_get $curr_RGB_list 2]

       polycolor $image_handle $r_color $g_color $b_color
   }

   proc get_time {} {
       set curr_time $::StimTime
       
       if { $::mri::Ephys_Seq::onset_time_needs_logging } {
	   dout .....1..
	   if { $::mri::Ephys_Seq::verbose_logging } {
	       puts "onset time is:"
	       puts $curr_time
	       puts -----------
	   }
	   # Store the real onset times in stimdg
	   dl_set stimdg:real_onset_in_run $curr_time
	   set ::mri::Ephys_Seq::onset_time_needs_logging 0
	   set ::mri::Ephys_Seq::time_just_exceeded_onset 0
       } elseif {$::mri::Ephys_Seq::offset_time_needs_logging } {
	   dout .....0..
	   if { $::mri::Ephys_Seq::verbose_logging } {
	       puts "offset time is:"
	       puts $curr_time
	       puts -----------
	   }
	   # Store the real offset times in stimdg	   
	   dl_set stimdg:real_offset_in_run $curr_time
	   set ::mri::Ephys_Seq::offset_time_needs_logging 0
       } else {
	   return
       }
   }

    proc run_is_over_check { last_run_index } {
	# If all the stim slots in this run have been reached, then the run
	# is over, and this proc douts.
	#set current_run $::mri::localizers::current_run 
	#set n_slots_per_run [dl_get stimdg:n_slots_per_run [expr $current_run - 1]]
	if { $::mri::Ephys_Seq::event_index_in_run > $last_run_index } {
	    # State system listens for this signal to go into the next state.
	    d_lo
	    puts "end_of_run $::mri::Ephys_Seq::current_run"
	    return 1
	} else {
	    return 0
	}
    }

    proc d_lo {} { dout ......0.;  }
    proc d_hi {} { dout ......1.;  }

}
