#
# PROTOCOL
#   emcalib/movie
#
# DESCRIPTION
#   Define calibration protocol for emcalib task
#
# AUTHOR
#   DLS
#

namespace eval movie {
    proc prot_init { } {
	# just get the stimcmds ready
	stimcmds
    }
    proc prot_destroy { } {
	# nothing to do for now
    }

    proc describe {} {
	return "Estimate calibration parameters for eye tracker with movies"
    }

    proc stimcmds {} {
	namespace inscope :: {
	    proc fixon {} {
		glistSetVisible 1; redraw
	    }

	    proc fixoff {} { 
		glistSetVisible 0; redraw; 
	    }

	    proc fixposition { x y } { 
		translateObj $::clip $x $y; redraw 
	    }

	    proc nexttrial {} {
		global fixspot
		glistInit 1
		resetObjList

		set nstims [dl_length stimdg:remaining]
		if { [dl_sum stimdg:remaining] == 0 } {
		    return "-1 $nstims $nstims"
		}
		set curstim [dl_pickone [dl_select stimdg:id stimdg:remaining]]

		set clipdir /shared/qpcs/stimuli/emcalib/clips/

		set clip [dl_get stimdg:clip $curstim]

		set obj [video ${clipdir}${clip}.bik]
		set ::clip $obj
		glistAddObject $obj 0
		glistSetDynamic 0 4
		scaleObj $obj [dl_get stimdg:scale $curstim]

		set ${::cur_namespace}::curstim $curstim
		return "$curstim [dl_get stimdg:jump_x $curstim] \
	                [dl_get stimdg:jump_y $curstim] \
	                [dl_sum [dl_not stimdg:remaining]] \
	                $nstims"
	    }
	
	    proc reset {} {
		glistSetVisible 0; redraw;
		dl_set stimdg:remaining [dl_ones [dl_length stimdg:remaining]]
	    }
	    
	    proc endtrial { status } {
		if { $status } {
		    dl_put stimdg:remaining [set ${::cur_namespace}::curstim] 0
		}
		return
	    }
	}
    }
}


